﻿

#region Usings
using System;
#endregion

namespace TwitterCNC
{
    /// <summary>
    /// Helper class to deal with Twitter
    /// </summary>
    public class Twitter
    {
        public static TwitterCNC.BOL.oAuthTwitter LoadTwitter(string Token, string TokenSecret, string PIN, string ConsumerKey, string ConsumerKeySecret)
        {
            myTwitter = new TwitterCNC.BOL.oAuthTwitter(Token, TokenSecret,PIN, ConsumerKey, ConsumerKeySecret);
            return myTwitter;
        }
        public static TwitterCNC.BOL.oAuthTwitter myTwitter = null;
        public static string LastResult = string.Empty;

        #region Public Functions
        /// <summary>
        /// Updates the status of the user
        /// </summary>
        /// <param name="Status">Status of the user (needs to be within 140 characters)</param>
        /// <returns>The XML doc returned from the Twitter service</returns>
        public static void SendTweet(string Status)
        {
            try
            {
                System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(delegate
                {
                    try
                    {
                        LastResult = _SendTweet(Status);
                    }
                    catch (System.Exception e)
                    {
                        string s = e.Message;
                        //  System.Windows.Forms.MessageBox.Show("Twitter Error:" + e.Message);
                    }
                }));
                t.IsBackground = true;
                t.Priority = System.Threading.ThreadPriority.Lowest;
                t.Start();
            }
            catch
            {
            }
          
        }
        private static string _SendTweet(string Status)
        {
            string sendTweet = Status;
            if (sendTweet.Length > 100)
                sendTweet = Status.Substring(0, 100);

            string result = UpdatSatus(sendTweet);

            if (Status.Length > 100)
                result += UpdatSatus(Status.Substring(100));

            return result;
        }

        public static string UpdatSatus(string Status)
        {
            return myTwitter.oAuthWebRequest(TwitterCNC.BOL.oAuthTwitter.Method.POST, "http://twitter.com/statuses/update.xml", "status=" + System.Web.HttpUtility.UrlEncode(Status));
        }
        #endregion
    }
}
